<?php
namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;


class LoadAllegroCategory extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;

    public function load(ObjectManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;

        $this->EntityManager->getConnection()->exec($this->sqlCat);
        $this->EntityManager->getConnection()->exec($this->sqlCatType);
        $this->EntityManager->getConnection()->exec($this->sqlAdvertService);
        $this->EntityManager->getConnection()->exec($this->sqlUsers);
        $this->EntityManager->getConnection()->exec($this->sqlCatItem);
        $this->EntityManager->getConnection()->exec($this->sqlCatItem1);
        $this->EntityManager->getConnection()->exec($this->sqlItems);
    }

    public function getOrder()
    {
        return 10;
    }

    private $sqlCatType = "INSERT INTO `allegro_category_item_type` (`id`, `name`, `symbol`) VALUES
(1, 'Nieruchomości', 'DOM'),
(2, 'Pojazdy', 'MOTO'),
(3, 'Komputery', 'KOMP'),
(4, 'Telefony', 'PHONE'),
(5, 'Inne', 'OTHER'),
(6, 'Biura', 'OFFICE'),
(7, 'Hale', 'DEPOT'),
(8, 'Magazyny', 'STOCKROOM');";

    private $sqlCat = "INSERT INTO `allegro_category` (`id`, `parent_id`, `title`, `cat_id`, `lft`, `lvl`, `rgt`, `root`) VALUES
(1, NULL, 'Nieruchomości', 20782, 1, 0, 17162, 1),
(7491, 1, 'Magazyny i hale do wynajęcia', 112750, 14980, 1, 15913, 1),
(6755, 1, 'Lokale i obiekty użytkowe do wynajęcia', 112749, 13508, 1, 14979, 1),
(6976, 6755, 'Mazowieckie', 119521, 13949, 2, 14106, 1),
(6981, 6976, 'Warszawa', 119672, 13958, 3, 13997, 1),
(7000, 6981, 'Inne', 120006, 13995, 4, 13996, 1),
(7001, 6976, 'Pow. białobrzeski', 119673, 13998, 3, 13999, 1),
(7002, 6976, 'Pow. ciechanowski', 119674, 14000, 3, 14001, 1),
(7003, 6976, 'Pow. garwoliński', 119675, 14002, 3, 14003, 1),
(7004, 6976, 'Pow. gostyniński', 119676, 14004, 3, 14005, 1),
(7005, 6976, 'Pow. grójecki', 119677, 14006, 3, 14007, 1),
(7006, 6976, 'Pow. grodziski', 119678, 14008, 3, 14009, 1),
(7007, 6976, 'Pow. kozienicki', 119679, 14010, 3, 14011, 1),
(7008, 6976, 'Pow. legionowski', 119680, 14012, 3, 14013, 1),
(7009, 6976, 'Pow. lipski', 119681, 14014, 3, 14015, 1),
(7010, 6976, 'Pow. łosicki', 119682, 14016, 3, 14017, 1),
(7011, 6976, 'Pow. makowski', 119683, 14018, 3, 14019, 1),
(7012, 6976, 'Pow. miński', 119684, 14020, 3, 14021, 1),
(7013, 6976, 'Pow. mławski', 119685, 14022, 3, 14023, 1),
(7014, 6976, 'Pow. nowodworski', 119686, 14024, 3, 14025, 1),
(7015, 6976, 'Pow. ostrołęcki', 119687, 14026, 3, 14027, 1),
(7016, 6976, 'Pow. ostrowski', 119688, 14028, 3, 14029, 1),
(7017, 6976, 'Pow. otwocki', 119689, 14030, 3, 14031, 1),
(7018, 6976, 'Pow. piaseczyński', 119690, 14032, 3, 14043, 1),
(7019, 7018, 'Góra Kalwaria', 120007, 14033, 4, 14034, 1),
(7020, 7018, 'Konstancin-Jeziorna', 120008, 14035, 4, 14036, 1),
(7021, 7018, 'Piaseczno', 120009, 14037, 4, 14038, 1),
(7022, 7018, 'Tarczyn', 120010, 14039, 4, 14040, 1),
(7023, 7018, 'Pozostałe', 120011, 14041, 4, 14042, 1),
(7024, 6976, 'Pow. płocki', 119691, 14044, 3, 14045, 1),
(7025, 6976, 'Pow. płoński', 119692, 14046, 3, 14047, 1),
(7026, 6976, 'Pow. pruszkowski', 119693, 14048, 3, 14057, 1),
(7027, 7026, 'Brwinów', 120012, 14049, 4, 14050, 1),
(7028, 7026, 'Piastów', 120013, 14051, 4, 14052, 1),
(7029, 7026, 'Pruszków', 120014, 14053, 4, 14054, 1),
(7030, 7026, 'Pozostałe', 120015, 14055, 4, 14056, 1),
(7031, 6976, 'Pow. przasnyski', 119694, 14058, 3, 14059, 1),
(7032, 6976, 'Pow. przysuski', 119695, 14060, 3, 14061, 1),
(7033, 6976, 'Pow. pułtuski', 119696, 14062, 3, 14063, 1),
(7034, 6976, 'Pow. radomski', 119697, 14064, 3, 14065, 1),
(7035, 6976, 'Pow. siedlecki', 119698, 14066, 3, 14067, 1),
(7036, 6976, 'Pow. sierpecki', 119699, 14068, 3, 14069, 1),
(7037, 6976, 'Pow. sochaczewski', 119700, 14070, 3, 14071, 1),
(7038, 6976, 'Pow. sokołowski', 119701, 14072, 3, 14073, 1),
(7039, 6976, 'Pow. szydłowiecki', 119702, 14074, 3, 14075, 1),
(7040, 6976, 'Pow. warszawski zachodni', 119703, 14076, 3, 14077, 1),
(7041, 6976, 'Pow. węgrowski', 119704, 14078, 3, 14079, 1),
(7042, 6976, 'Pow. wołomiński', 119705, 14080, 3, 14097, 1),
(7043, 7042, 'Kobyłka', 120016, 14081, 4, 14082, 1),
(7044, 7042, 'Marki', 120017, 14083, 4, 14084, 1),
(7045, 7042, 'Radzymin', 120018, 14085, 4, 14086, 1),
(7046, 7042, 'Tłuszcz', 120019, 14087, 4, 14088, 1),
(7047, 7042, 'Wołomin', 120020, 14089, 4, 14090, 1),
(7048, 7042, 'Ząbki', 120021, 14091, 4, 14092, 1),
(7049, 7042, 'Zielonka', 120022, 14093, 4, 14094, 1),
(7050, 7042, 'Pozostałe', 120023, 14095, 4, 14096, 1),
(7051, 6976, 'Pow. wyszkowski', 119706, 14098, 3, 14099, 1),
(7052, 6976, 'pow. zwoleński', 119707, 14100, 3, 14101, 1),
(7053, 6976, 'Pow. żuromiński', 119708, 14102, 3, 14103, 1),
(7054, 6976, 'Pow. żyrardowski', 119709, 14104, 3, 14105, 1),
(7055, 6755, 'Opolskie', 119522, 14107, 2, 14160, 1),
(7056, 7055, 'Opole', 119710, 14108, 3, 14137, 1),
(7057, 7056, 'Bierkowice', 120024, 14109, 4, 14110, 1),
(7058, 7056, 'Gosławice', 120025, 14111, 4, 14112, 1),
(7059, 7056, 'Groszowice', 120026, 14113, 4, 14114, 1),
(7060, 7056, 'Grudzice', 120027, 14115, 4, 14116, 1),
(7061, 7056, 'Kolonia Gosławicka', 120028, 14117, 4, 14118, 1),
(7062, 7056, 'Malina', 120029, 14119, 4, 14120, 1),
(7063, 7056, 'Nowa Wieś Królewska', 120030, 14121, 4, 14122, 1),
(7064, 7056, 'Półwieś', 120031, 14123, 4, 14124, 1),
(7065, 7056, 'Szczepanowice', 120032, 14125, 4, 14126, 1),
(7066, 7056, 'Wójtowa Wieś', 120033, 14127, 4, 14128, 1),
(7067, 7056, 'Wróblin', 120034, 14129, 4, 14130, 1),
(7068, 7056, 'Zakrzów', 120035, 14131, 4, 14132, 1),
(7069, 7056, 'Zaodrze', 120036, 14133, 4, 14134, 1),
(7070, 7056, 'Pozostałe', 120037, 14135, 4, 14136, 1),
(7071, 7055, 'Pow. brzeski', 119711, 14138, 3, 14139, 1),
(7072, 7055, 'Pow. głubczycki', 119712, 14140, 3, 14141, 1),
(7073, 7055, 'Pow. kędzierzyńsko-kozielski', 119713, 14142, 3, 14143, 1),
(7074, 7055, 'Pow. kluczborski', 119714, 14144, 3, 14145, 1),
(7075, 7055, 'Pow. krapkowicki', 119715, 14146, 3, 14147, 1),
(7076, 7055, 'Pow. namysłowski', 119716, 14148, 3, 14149, 1),
(7077, 7055, 'Pow. nyski', 119717, 14150, 3, 14151, 1),
(7078, 7055, 'Pow. oleski', 119718, 14152, 3, 14153, 1),
(7079, 7055, 'Pow. opolski', 119719, 14154, 3, 14155, 1),
(7080, 7055, 'Pow. prudnicki', 119720, 14156, 3, 14157, 1),
(7081, 7055, 'Pow. strzelecki', 119721, 14158, 3, 14159, 1),
(7082, 6755, 'Podkarpackie', 119523, 14161, 2, 14238, 1),
(7083, 7082, 'Krosno', 119722, 14162, 3, 14163, 1),
(7084, 7082, 'Przemyśl', 119723, 14164, 3, 14165, 1),
(7085, 7082, 'Rzeszów', 119724, 14166, 3, 14193, 1),
(7086, 7085, 'Drabinianka', 120038, 14167, 4, 14168, 1),
(7087, 7085, 'Dworzysko', 120039, 14169, 4, 14170, 1),
(7088, 7085, 'Pobitno', 120040, 14171, 4, 14172, 1),
(7089, 7085, 'Przybyszówka', 120041, 14173, 4, 14174, 1),
(7090, 7085, 'Słocina', 120042, 14175, 4, 14176, 1),
(7091, 7085, 'Staromieście', 120043, 14177, 4, 14178, 1),
(7092, 7085, 'Staroniwa', 120044, 14179, 4, 14180, 1),
(7093, 7085, 'Szajerówka', 120045, 14181, 4, 14182, 1),
(7094, 7085, 'Wilkowyja', 120046, 14183, 4, 14184, 1),
(7095, 7085, 'Zalesie', 120047, 14185, 4, 14186, 1),
(7096, 7085, 'Załęże', 120048, 14187, 4, 14188, 1),
(7097, 7085, 'Zwięczyca', 120049, 14189, 4, 14190, 1),
(7098, 7085, 'Pozostałe', 120050, 14191, 4, 14192, 1),
(7099, 7082, 'Tarnobrzeg', 119725, 14194, 3, 14195, 1),
(7100, 7082, 'Pow. bieszczadzki', 119726, 14196, 3, 14197, 1),
(7101, 7082, 'Pow. brzozowski', 119727, 14198, 3, 14199, 1),
(7102, 7082, 'Pow. dębicki', 119728, 14200, 3, 14201, 1),
(7103, 7082, 'Pow. jarosławski', 119729, 14202, 3, 14203, 1),
(7104, 7082, 'Pow. jasielski', 119730, 14204, 3, 14205, 1),
(7105, 7082, 'Pow. kolbuszowski', 119731, 14206, 3, 14207, 1),
(7106, 7082, 'Pow. krośnieński', 119732, 14208, 3, 14209, 1),
(7107, 7082, 'Pow. leski', 119733, 14210, 3, 14211, 1),
(7108, 7082, 'Pow. leżajski', 119734, 14212, 3, 14213, 1),
(7109, 7082, 'Pow. lubaczowski', 119735, 14214, 3, 14215, 1),
(7110, 7082, 'Pow. łańcucki', 119736, 14216, 3, 14217, 1),
(7111, 7082, 'Pow. mielecki', 119737, 14218, 3, 14219, 1),
(7112, 7082, 'Pow. niżański', 119738, 14220, 3, 14221, 1),
(7113, 7082, 'Pow. przemyski', 119739, 14222, 3, 14223, 1),
(7114, 7082, 'Pow. przeworski', 119740, 14224, 3, 14225, 1),
(7115, 7082, 'Pow. ropczycko-sędziszowski', 119741, 14226, 3, 14227, 1),
(7116, 7082, 'Pow. rzeszowski', 119742, 14228, 3, 14229, 1),
(7117, 7082, 'Pow. sanocki', 119743, 14230, 3, 14231, 1),
(7118, 7082, 'Pow. stalowowolski', 119744, 14232, 3, 14233, 1),
(7119, 7082, 'Pow. strzyżowski', 119745, 14234, 3, 14235, 1),
(7120, 7082, 'Pow. tarnobrzeski', 119746, 14236, 3, 14237, 1),
(7121, 6755, 'Podlaskie', 119524, 14239, 2, 14306, 1),
(7122, 7121, 'Białystok', 119747, 14240, 3, 14273, 1),
(7123, 7122, 'Antoniuk', 120051, 14241, 4, 14242, 1),
(7124, 7122, 'Bacieczki', 120052, 14243, 4, 14244, 1),
(7125, 7122, 'Białostoczek', 120053, 14245, 4, 14246, 1),
(7126, 7122, 'Bojary', 120054, 14247, 4, 14248, 1),
(7127, 7122, 'Dojlidy', 120055, 14249, 4, 14250, 1),
(7128, 7122, 'Dojlidy Górne', 120056, 14251, 4, 14252, 1),
(7129, 7122, 'Dziesięciny', 120057, 14253, 4, 14254, 1),
(7130, 7122, 'Nowe Miasto', 120058, 14255, 4, 14256, 1),
(7131, 7122, 'Skorupy', 120059, 14257, 4, 14258, 1),
(7132, 7122, 'Słoboda', 120060, 14259, 4, 14260, 1),
(7133, 7122, 'Starosielce', 120061, 14261, 4, 14262, 1),
(7134, 7122, 'Wygoda', 120062, 14263, 4, 14264, 1),
(7135, 7122, 'Wysoki Stoczek', 120063, 14265, 4, 14266, 1),
(7136, 7122, 'Zagórki', 120064, 14267, 4, 14268, 1),
(7137, 7122, 'Zawady', 120065, 14269, 4, 14270, 1),
(7138, 7122, 'Pozostałe', 120066, 14271, 4, 14272, 1),
(7139, 7121, 'Łomża', 119748, 14274, 3, 14275, 1),
(7140, 7121, 'Suwałki', 119749, 14276, 3, 14277, 1),
(7141, 7121, 'Pow. augustowski', 119750, 14278, 3, 14279, 1),
(7142, 7121, 'Pow. białostocki', 119751, 14280, 3, 14281, 1),
(7143, 7121, 'Pow. bielski', 119752, 14282, 3, 14283, 1),
(7144, 7121, 'Pow. grajewski', 119753, 14284, 3, 14285, 1),
(7145, 7121, 'Pow. hajnowski', 119754, 14286, 3, 14287, 1),
(7146, 7121, 'Pow. kolneński', 119755, 14288, 3, 14289, 1),
(7147, 7121, 'Pow. łomżyński', 119756, 14290, 3, 14291, 1),
(7148, 7121, 'Pow. moniecki', 119757, 14292, 3, 14293, 1),
(7149, 7121, 'Pow. sejneński', 119758, 14294, 3, 14295, 1),
(7150, 7121, 'Pow. siemiatycki', 119759, 14296, 3, 14297, 1),
(7151, 7121, 'Pow. sokólski', 119760, 14298, 3, 14299, 1),
(7152, 7121, 'Pow. suwalski', 119761, 14300, 3, 14301, 1),
(7153, 7121, 'Pow. wysokomazowiecki', 119762, 14302, 3, 14303, 1),
(7154, 7121, 'Pow. zambrowski', 119763, 14304, 3, 14305, 1),
(7155, 6755, 'Pomorskie', 119525, 14307, 2, 14434, 1),
(7156, 7155, 'Gdańsk', 119764, 14308, 3, 14341, 1),
(7157, 7156, 'Brzeźno', 120067, 14309, 4, 14310, 1),
(7158, 7156, 'Chełm', 120068, 14311, 4, 14312, 1),
(7159, 7156, 'Jasień', 120069, 14313, 4, 14314, 1),
(7160, 7156, 'Kiełpino Górne', 120070, 14315, 4, 14316, 1),
(7161, 7156, 'Kokoszki', 120071, 14317, 4, 14318, 1),
(7162, 7156, 'Lipce', 120072, 14319, 4, 14320, 1),
(7163, 7156, 'Łostowice', 120073, 14321, 4, 14322, 1),
(7164, 7156, 'Oliwa', 120074, 14323, 4, 14324, 1),
(7165, 7156, 'Osowa', 120075, 14325, 4, 14326, 1),
(7166, 7156, 'Przymorze', 120076, 14327, 4, 14328, 1),
(7167, 7156, 'Siedlce', 120077, 14329, 4, 14330, 1),
(7168, 7156, 'Sobieszewo', 120078, 14331, 4, 14332, 1),
(7169, 7156, 'Suchanino', 120079, 14333, 4, 14334, 1),
(7170, 7156, 'Wrzeszcz', 120080, 14335, 4, 14336, 1),
(7171, 7156, 'Zakoniczyn', 120081, 14337, 4, 14338, 1),
(7172, 7156, 'Pozostałe', 120082, 14339, 4, 14340, 1),
(7173, 7155, 'Gdynia', 119765, 14342, 3, 14375, 1),
(7174, 7173, 'Chwarzno', 120083, 14343, 4, 14344, 1),
(7175, 7173, 'Chylonia', 120084, 14345, 4, 14346, 1),
(7176, 7173, 'Cisowa', 120085, 14347, 4, 14348, 1),
(7177, 7173, 'Działki Leśne', 120086, 14349, 4, 14350, 1),
(7178, 7173, 'Kamienna Góra', 120087, 14351, 4, 14352, 1),
(7179, 7173, 'Leszczynki', 120088, 14353, 4, 14354, 1),
(7180, 7173, 'Mały Kack', 120089, 14355, 4, 14356, 1),
(7181, 7173, 'Obłuże', 120090, 14357, 4, 14358, 1),
(7182, 7173, 'Oksywie', 120091, 14359, 4, 14360, 1),
(7183, 7173, 'Orłowo', 120092, 14361, 4, 14362, 1),
(7184, 7173, 'Pogórze', 120093, 14363, 4, 14364, 1),
(7185, 7173, 'Redłowo', 120094, 14365, 4, 14366, 1),
(7186, 7173, 'Wiczlino', 120095, 14367, 4, 14368, 1),
(7187, 7173, 'Wielki Kack', 120096, 14369, 4, 14370, 1),
(7188, 7173, 'Wzgórze Nowotki', 120097, 14371, 4, 14372, 1),
(7189, 7173, 'Pozostałe', 120098, 14373, 4, 14374, 1),
(7190, 7155, 'Słupsk', 119766, 14376, 3, 14377, 1),
(7191, 7155, 'Sopot', 119767, 14378, 3, 14393, 1),
(7192, 7191, 'Brodwino', 120099, 14379, 4, 14380, 1),
(7193, 7191, 'Kamienny Potok', 120100, 14381, 4, 14382, 1),
(7194, 7191, 'Przylesie', 120101, 14383, 4, 14384, 1),
(7195, 7191, 'Sopot Dolny', 120102, 14385, 4, 14386, 1),
(7196, 7191, 'Sopot Górny', 120103, 14387, 4, 14388, 1),
(7197, 7191, 'Wyścigi', 120104, 14389, 4, 14390, 1),
(7198, 7191, 'Pozostałe', 120105, 14391, 4, 14392, 1),
(7199, 7155, 'Pow. bytowski', 119768, 14394, 3, 14395, 1),
(7200, 7155, 'Pow. chojnicki', 119769, 14396, 3, 14397, 1),
(7722, 7491, 'Opolskie', 120257, 15441, 2, 15466, 1),
(7730, 7722, 'Pow. nyski', 120452, 15456, 3, 15457, 1),
(7731, 7722, 'Pow. oleski', 120453, 15458, 3, 15459, 1),
(7732, 7722, 'Pow. opolski', 120454, 15460, 3, 15461, 1),
(7733, 7722, 'Pow. prudnicki', 120455, 15462, 3, 15463, 1),
(7734, 7722, 'Pow. strzelecki', 120456, 15464, 3, 15465, 1),
(7735, 7491, 'Podkarpackie', 120258, 15467, 2, 15518, 1),
(7736, 7735, 'Krosno', 120457, 15468, 3, 15469, 1),
(7737, 7735, 'Przemyśl', 120458, 15470, 3, 15471, 1),
(7738, 7735, 'Rzeszów', 120459, 15472, 3, 15473, 1),
(7739, 7735, 'Tarnobrzeg', 120460, 15474, 3, 15475, 1),
(7740, 7735, 'Pow. bieszczadzki', 120461, 15476, 3, 15477, 1),
(7741, 7735, 'Pow. brzozowski', 120462, 15478, 3, 15479, 1),
(7742, 7735, 'Pow. dębicki', 120463, 15480, 3, 15481, 1),
(7743, 7735, 'Pow. jarosławski', 120464, 15482, 3, 15483, 1),
(7744, 7735, 'Pow. jasielski', 120465, 15484, 3, 15485, 1),
(7745, 7735, 'Pow. kolbuszowski', 120466, 15486, 3, 15487, 1),
(7746, 7735, 'Pow. krośnieński', 120467, 15488, 3, 15489, 1),
(7747, 7735, 'Pow. leski', 120468, 15490, 3, 15491, 1),
(7748, 7735, 'Pow. leżajski', 120469, 15492, 3, 15493, 1),
(7749, 7735, 'Pow. lubaczowski', 120470, 15494, 3, 15495, 1),
(7750, 7735, 'Pow. łańcucki', 120471, 15496, 3, 15497, 1),
(7751, 7735, 'Pow. mielecki', 120472, 15498, 3, 15499, 1),
(7752, 7735, 'Pow. niżański', 120473, 15500, 3, 15501, 1),
(7753, 7735, 'Pow. przemyski', 120474, 15502, 3, 15503, 1),
(7754, 7735, 'Pow. przeworski', 120475, 15504, 3, 15505, 1),
(7755, 7735, 'Pow. ropczycko-sędziszowski', 120476, 15506, 3, 15507, 1),
(7756, 7735, 'Pow. rzeszowski', 120477, 15508, 3, 15509, 1),
(7757, 7735, 'Pow. sanocki', 120478, 15510, 3, 15511, 1),
(7758, 7735, 'Pow. stalowowolski', 120479, 15512, 3, 15513, 1),
(7759, 7735, 'Pow. strzyżowski', 120480, 15514, 3, 15515, 1),
(7760, 7735, 'Pow. tarnobrzeski', 120481, 15516, 3, 15517, 1),
(7761, 7491, 'Podlaskie', 120259, 15519, 2, 15554, 1),
(7762, 7761, 'Białystok', 120482, 15520, 3, 15521, 1),
(7763, 7761, 'Łomża', 120483, 15522, 3, 15523, 1),
(7764, 7761, 'Suwałki', 120484, 15524, 3, 15525, 1),
(7765, 7761, 'Pow. augustowski', 120485, 15526, 3, 15527, 1),
(7766, 7761, 'Pow. białostocki', 120486, 15528, 3, 15529, 1),
(7767, 7761, 'Pow. bielski', 120487, 15530, 3, 15531, 1),
(7768, 7761, 'Pow. grajewski', 120488, 15532, 3, 15533, 1),
(7769, 7761, 'Pow. hajnowski', 120489, 15534, 3, 15535, 1),
(7770, 7761, 'Pow. kolneński', 120490, 15536, 3, 15537, 1);
";
//"; private $A="

    private $sqlCatItem = "INSERT INTO `allegro_category_item` (`id`, `category_id`, `advert_service_id`, `user_id`, `item_id`, `name`, `buy_now_price`, `ending_time`, `city`, `state`, `country`, `thumb_url`, `id_in_advert_service`, `period_of_notice`, `bail`, `surface`, `type_id`) VALUES
(332, 7083, 2, 1, 3666942814, 'Lokal, Krosno', 4300, '2013-11-20 13:02:50', 'Krosno', 9, 1, 'http://img15.allegroimg.pl/photos/128x96/36/66/94/28/3666942814', '20319995', 1, 4300, 200, 6),
(342, 7083, 2, 1, 3667757195, 'Lokal, Krosno, Wojska Polskiego', 3384, '2013-11-28 05:06:30', 'Krosno', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/36/67/75/71/3667757195', '15877017', 2, 3384, 169.2, 6),
(348, 7083, 2, 1, 3678328333, 'Lokal, Krosno', 1300, '2013-12-02 09:12:47', 'Krosno', 9, 1, 'http://img14.allegroimg.pl/photos/128x96/36/78/32/83/3678328333', '21567300', 2, 1950, 52, 6),
(352, 7083, 2, 1, 3684448289, 'Lokal, Krosno, CENTRUM KROSNA', 1800, '2013-12-04 14:18:45', 'Krosno', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/36/84/44/82/3684448289', '21059109', 1, 3600, 86, 6),
(365, 7083, 2, 1, 3713022009, 'Lokal, Krosno', 3200, '2013-12-14 16:13:48', 'Krosno', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/37/13/02/20/3713022009', '21783495', 2, 3200, 83.74, 6),
(368, 7083, 2, 1, 3717983834, 'Lokal, Krosno', 2500, '2013-12-16 12:09:42', 'Krosno', 9, 1, 'http://img15.allegroimg.pl/photos/128x96/37/17/98/38/3717983834', '18645113', 2, 2500, 85, 6),
(371, 7083, 2, 1, 3722883254, 'Lokal, Krosno', 1300, '2013-12-18 08:07:38', 'Krosno', 9, 1, 'http://img15.allegroimg.pl/photos/128x96/37/22/88/32/3722883254', '8828053', 2, 1300, 49, 6),
(374, 7084, 2, 1, 3660266319, 'Lokal, Przemyśl', 4500, '2013-11-25 10:10:29', 'Przemyśl', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/36/60/26/63/3660266319', '19545263', 2, 4500, 130, 6),
(375, 7084, 2, 1, 3666698882, 'Lokal, Przemyśl', 4800, '2013-11-27 18:08:24', 'Przemyśl', 9, 1, 'http://img03.allegroimg.pl/photos/128x96/36/66/69/88/3666698882', '10418458', 2, 7200, 240, 6),
(385, 7084, 2, 1, 3708312101, 'Lokal, Przemyśl, Bohaterów Getta', 3000, '2013-12-13 00:12:49', 'Przemyśl', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/37/08/31/21/3708312101', '21746951', 1, 6000, 160, 6),
(387, 7084, 2, 1, 3717157629, 'Lokal, Przemyśl, Grunwaldzka', 3500, '2013-12-15 23:14:41', 'Przemyśl', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/37/17/15/76/3717157629', '21807047', 2, 3500, 210, 6),
(389, 7084, 2, 1, 3717235975, 'Lokal, Przemyśl', 3200, '2013-12-16 00:09:42', 'Przemyśl', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/37/17/23/59/3717235975', '18148993', 2, 3200, 160, 6),
(396, 7084, 2, 1, 3717284705, 'Lokal, Przemyśl', 5520, '2013-12-16 01:11:58', 'Przemyśl', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/37/17/28/47/3717284705', '18149449', 2, 5520, 138, 6),
(399, 7084, 2, 1, 3717284789, 'Lokal, Przemyśl', 3250, '2013-12-16 01:11:58', 'Przemyśl', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/37/17/28/47/3717284789', '18149436', 2, 3250, 250, 6),
(401, 7084, 2, 1, 3717284798, 'Lokal, Przemyśl', 5500, '2013-12-16 01:11:58', 'Przemyśl', 9, 1, 'http://img19.allegroimg.pl/photos/128x96/37/17/28/47/3717284798', '18149471', 2, 5500, 103.96, 6),
(405, 7084, 2, 1, 3717285147, 'Lokal, Przemyśl', 7000, '2013-12-16 01:12:09', 'Przemyśl', 9, 1, '', '18150030', 2, 7000, 100, 6),
(410, 7084, 2, 1, 3717314650, 'Lokal, Przemyśl', 3740, '2013-12-16 03:09:38', 'Przemyśl', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/37/17/31/46/3717314650', '18153196', 2, 3740, 170, 6),
(412, 7084, 2, 1, 3719837008, 'Lokal, Przemyśl', 2860, '2013-12-17 02:10:36', 'Przemyśl', 9, 1, '', '11245280', 2, 2860, 220, 6),
(419, 7086, 2, 1, 3666942711, 'Lokal, Rzeszów, Drabinianka', 2640, '2013-11-20 13:02:56', 'Rzeszów', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/36/66/94/27/3666942711', '20320361', 1, 2640, 240, 6),
(421, 7086, 2, 1, 3657979848, 'Lokal, Rzeszów, Drabinianka', 1400, '2013-11-24 12:03:30', 'Rzeszów', 9, 1, 'http://img09.allegroimg.pl/photos/128x96/36/57/97/98/3657979848', '19294010', 2, 2100, 88, 6),
(426, 7086, 2, 1, 3693067948, 'Lokal, Rzeszów, Drabinianka', 1500, '2013-12-07 14:11:13', 'Rzeszów', 9, 1, 'http://img09.allegroimg.pl/photos/128x96/36/93/06/79/3693067948', '21017352', 1, 2250, 60, 6),
(432, 7088, 2, 1, 3729174147, 'Lokal, Rzeszów, Pobitno', 2100, '2013-12-20 09:10:00', 'Rzeszów', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/37/29/17/41/3729174147', '5748487', 1, 2100, 70, 6),
(433, 7089, 2, 1, 3679974185, 'Lokal, Rzeszów, Przybyszówka, Dębicka', 2500, '2013-12-02 19:42:05', 'Rzeszów', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/79/97/41/3679974185', '14376483', 1, 2500, 120, 6),
(434, 7089, 2, 1, 3679976861, 'Lokal, Rzeszów, Przybyszówka, Boya Żeleńskiego', 3690, '2013-12-02 19:45:24', 'Rzeszów', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/36/79/97/68/3679976861', '13185021', 2, 5535, 198, 6),
(436, 7089, 2, 1, 3727568941, 'Lokal, Rzeszów, Przybyszówka', 6000, '2013-12-19 17:08:34', 'Rzeszów', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/37/27/56/89/3727568941', '7884028', 1, 6000, 200, 6),
(438, 7090, 2, 1, 3727295292, 'Lokal, Rzeszów, Słocina, Paderewskiego', 18600, '2013-11-24 13:04:29', 'Rzeszów', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/37/27/29/52/3727295292', '20877474', 1, 37200, 186.66, 6),
(440, 7090, 2, 1, 3675232652, 'Lokal, Rzeszów, Słocina, Armii Krajowej', 4500, '2013-11-30 20:43:13', 'Rzeszów', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/36/75/23/26/3675232652', '22069410', 2, 4500, 229, 6),
(441, 7090, 2, 1, 3727300991, 'Lokal, Rzeszów, Słocina, Armii Krajowej', 1600, '2013-12-19 15:29:48', 'Rzeszów', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/37/27/30/09/3727300991', '15804528', 1, 1600, 160, 6),
(451, 7091, 2, 1, 3671335856, 'Lokal, Rzeszów, Staromieście, Siemieńskiego', 2000, '2013-11-29 13:18:06', 'Rzeszów', 9, 1, 'http://img17.allegroimg.pl/photos/128x96/36/71/33/58/3671335856', '20825209', 2, 2000, 47, 6),
(458, 7091, 2, 1, 3714967584, 'Lokal, Rzeszów, Staromieście', 5750, '2013-12-15 10:08:53', 'Rzeszów', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/37/14/96/75/3714967584', '18478791', 2, 5750, 230, 6),
(466, 7091, 2, 1, 3727300935, 'Lokal, Rzeszów, Staromieście, Siemieńskiego', 4000, '2013-12-19 15:29:44', 'Rzeszów', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/37/27/30/09/3727300935', '16391649', 1, 8000, 160, 6),
(471, 7091, 2, 1, 3727315522, 'Lokal, Rzeszów, Staromieście, Warszawska', 3900, '2013-12-19 15:33:50', 'Rzeszów', 9, 1, 'http://img03.allegroimg.pl/photos/128x96/37/27/31/55/3727315522', '11424052', 1, 5850, 200, 6),
(472, 7091, 2, 1, 3727315533, 'Lokal, Rzeszów, Staromieście, Warszawska', 4900, '2013-12-19 15:33:50', 'Rzeszów', 9, 1, 'http://img14.allegroimg.pl/photos/128x96/37/27/31/55/3727315533', '11424037', 1, 4900, 200, 6),
(473, 7091, 2, 1, 3727315589, 'Lokal, Rzeszów, Staromieście, Warszawska', 11900, '2013-12-19 15:33:50', 'Rzeszów', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/37/27/31/55/3727315589', '11424032', 1, 11900, 200, 6),
(481, 7092, 2, 1, 3679993310, 'Lokal, Rzeszów, Staroniwa, Przemysłowa', 2415, '2013-12-02 19:52:43', 'Rzeszów', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/36/79/99/33/3679993310', '8157357', 1, 2415, 105, 6),
(483, 7092, 2, 1, 3693035025, 'Lokal, Rzeszów, Staroniwa, Przemysłowa', 5821, '2013-12-07 14:00:55', 'Rzeszów', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/93/03/50/3693035025', '11228052', 1, 5821, 232, 6),
(485, 7092, 2, 1, 3718214331, 'Lokal, Rzeszów, Staroniwa, Boya Żeleńskiego', 5265, '2013-12-16 13:56:37', 'Rzeszów', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/37/18/21/43/3718214331', '13236915', 1, 5265, 195, 6),
(486, 7092, 2, 1, 3727299647, 'Lokal, Rzeszów, Staroniwa, Przemysłowa', 3000, '2013-12-19 15:28:40', 'Rzeszów', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/37/27/29/96/3727299647', '17768274', 2, 3000, 170, 6),
(489, 7092, 2, 1, 3727300797, 'Lokal, Rzeszów, Staroniwa, Przemysłowa', 3024, '2013-12-19 15:29:20', 'Rzeszów', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/37/27/30/07/3727300797', '16589547', 1, 3024, 216, 6),
(494, 7095, 2, 1, 3724180551, 'Lokal, Rzeszów, Zalesie, Zalesie', 6380, '2013-12-18 15:25:52', 'Rzeszów', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/37/24/18/05/3724180551', '20781376', 1, 6380, 220, 6),
(495, 7095, 2, 1, 3727301059, 'Lokal, Rzeszów, Zalesie, Łukasiewicza', 4000, '2013-12-19 15:29:50', 'Rzeszów', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/37/27/30/10/3727301059', '15487474', 2, 4000, 200, 6),
(497, 7097, 2, 1, 3666942360, 'Lokal, Rzeszów, Zwięczyca', 9500, '2013-11-20 13:03:05', 'Rzeszów', 9, 1, '', '20320573', 1, 9500, 187, 6),
(499, 7097, 2, 1, 3651744392, 'Lokal, Rzeszów, Zwięczyca', 4480, '2013-11-22 09:17:54', 'Rzeszów', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/36/51/74/43/3651744392', '9874482', 1, 4480, 100, 6),
(504, 7097, 2, 1, 3675232694, 'Lokal, Rzeszów, Zwięczyca', 2700, '2013-11-30 20:43:51', 'Rzeszów', 9, 1, 'http://img15.allegroimg.pl/photos/128x96/36/75/23/26/3675232694', '22069426', 1, 2700, 180, 6),
(505, 7097, 2, 1, 3679977847, 'Lokal, Rzeszów, Zwięczyca, Podkarpacka', 1200, '2013-12-02 19:46:40', 'Rzeszów', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/36/79/97/78/3679977847', '12483015', 2, 1200, 60, 6),
(514, 7097, 2, 1, 3727299520, 'Lokal, Rzeszów, Zwięczyca, Boya Żeleńskiego', 4000, '2013-12-19 15:28:04', 'Rzeszów', 9, 1, 'http://img01.allegroimg.pl/photos/128x96/37/27/29/95/3727299520', '19445131', 1, 4000, 220, 6),
(517, 7097, 2, 1, 3727299762, 'Lokal, Rzeszów, Zwięczyca, Podkarpacka', 3000, '2013-12-19 15:28:42', 'Rzeszów', 9, 1, 'http://img03.allegroimg.pl/photos/128x96/37/27/29/97/3727299762', '17557047', 2, 3000, 150, 6),
(519, 7097, 2, 1, 3727299700, 'Lokal, Rzeszów, Zwięczyca, Podkarpacka', 2200, '2013-12-19 15:28:46', 'Rzeszów', 9, 1, 'http://img01.allegroimg.pl/photos/128x96/37/27/29/97/3727299700', '17357436', 1, 3300, 90, 6),
(532, 7098, 2, 1, 3666942801, 'Lokal, Rzeszów, Śródmieście-Południe', 3700, '2013-11-20 13:02:52', 'Rzeszów', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/36/66/94/28/3666942801', '20320136', 2, 5550, 200, 6),
(534, 7098, 2, 1, 3666942829, 'Lokal, Rzeszów, Śródmieście-Południe', 3990, '2013-11-20 13:02:53', 'Rzeszów', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/36/66/94/28/3666942829', '20320188', 2, 3990, 114, 6),
(536, 7098, 2, 1, 3666942747, 'Lokal, Rzeszów', 2280, '2013-11-20 13:02:56', 'Rzeszów', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/36/66/94/27/3666942747', '20320373', 2, 2280, 57, 6),
(545, 7098, 2, 1, 3666942489, 'Lokal, Rzeszów', 3600, '2013-11-20 13:03:02', 'Rzeszów', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/36/66/94/24/3666942489', '20320521', 2, 3600, 120, 6),
(550, 7098, 2, 1, 3666942379, 'Lokal, Rzeszów', 3200, '2013-11-20 13:03:03', 'Rzeszów', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/36/66/94/23/3666942379', '20320532', 1, 3200, 80, 6),
(552, 7098, 2, 1, 3666942368, 'Lokal, Rzeszów', 7120, '2013-11-20 13:03:04', 'Rzeszów', 9, 1, 'http://img09.allegroimg.pl/photos/128x96/36/66/94/23/3666942368', '20320558', 2, 7120, 89, 6),
(557, 7098, 2, 1, 3666942390, 'Lokal, Rzeszów, Paderewskiego', 9500, '2013-11-20 13:03:06', 'Rzeszów', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/36/66/94/23/3666942390', '20320586', 2, 9500, 250, 6),
(561, 7098, 2, 1, 3646871518, 'Lokal, Rzeszów, Centrum, Centrum', 1500, '2013-11-20 13:49:21', 'Rzeszów', 9, 1, 'http://img19.allegroimg.pl/photos/128x96/36/46/87/15/3646871518', '20204485', 1, 100, 175, 6),
(565, 7098, 2, 1, 3727295296, 'Lokal, Rzeszów, Kmity, Kmity', 5200, '2013-11-21 10:36:42', 'Rzeszów', 9, 1, 'http://img17.allegroimg.pl/photos/128x96/37/27/29/52/3727295296', '14192295', 1, 5200, 216, 6),
(569, 7098, 2, 1, 3649712517, 'Lokal, Rzeszów', 1200, '2013-11-21 13:50:34', 'Rzeszów', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/36/49/71/25/3649712517', '11971053', 1, 120, 180, 6),
(570, 7098, 2, 1, 3649713380, 'Lokal, Rzeszów', 2500, '2013-11-21 13:51:13', 'Rzeszów', 9, 1, 'http://img01.allegroimg.pl/photos/128x96/36/49/71/33/3649713380', '10389526', 2, 2500, 250, 6),
(575, 7098, 2, 1, 3650796695, 'Lokal, Rzeszów', 1800, '2013-11-21 20:15:57', 'Rzeszów', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/36/50/79/66/3650796695', '21910681', 2, 1800, 150, 6),
(576, 7098, 2, 1, 3650796701, 'Lokal, Rzeszów', 2112, '2013-11-21 20:15:59', 'Rzeszów', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/36/50/79/67/3650796701', '21910686', 1, 2112, 176, 6),
(580, 7099, 2, 1, 3713512216, 'Lokal, Tarnobrzeg, Centrum, Moniuszki/Mickiewicza', 3000, '2013-12-14 18:47:04', 'Tarnobrzeg', 9, 1, 'http://img17.allegroimg.pl/photos/128x96/37/13/51/22/3713512216', '22302922', 2, 3000, 100, 6),
(583, 7100, 1, 12, 3712010237, 'Do wynajęcia lokal w centrum Ustrzyk Dolnych', 15000, '2013-11-28 11:56:43', 'Ustrzyki Dolne', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/37/12/01/02/3712010237', '', 1, 15000, 250, 6),
(591, 7102, 2, 1, 3668944907, 'Lokal, Pilzno', 1500, '2013-11-28 15:13:20', 'Pilzno', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/36/68/94/49/3668944907', '16512958', 1, 1500, 100, 6),
(595, 7102, 2, 1, 3708668713, 'Lokal, Dębica, Centrum, Rynek', 8000, '2013-12-13 09:09:51', 'Dębica', 9, 1, 'http://img14.allegroimg.pl/photos/128x96/37/08/66/87/3708668713', '7278213', 2, 8000, 100, 6),
(605, 7103, 2, 1, 3689263838, 'Lokal, Jarosław, Grunwaldzka 3', 1400, '2013-12-06 07:58:06', 'Jarosław', 9, 1, 'http://img19.allegroimg.pl/photos/128x96/36/89/26/38/3689263838', '19832385', 2, 1400, 105, 6),
(608, 7103, 2, 1, 3694094865, 'Lokal, Jarosław', 900, '2013-12-07 20:01:43', 'Jarosław', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/94/09/48/3694094865', '13511610', 1, 900, 70, 6),
(627, 7104, 2, 1, 3668919245, 'Lokal, Kołaczyce', 3000, '2013-11-28 15:08:17', 'Kołaczyce', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/68/91/92/3668919245', '8022157', 1, 3000, 160, 6),
(631, 7104, 2, 1, 3689945990, 'Lokal, Jasło', 2400, '2013-12-06 12:09:09', 'Jasło', 9, 1, '', '20611016', 2, 2400, 120, 6),
(636, 7105, 2, 1, 3711797443, 'Lokal, Kolbuszowa', 2000, '2013-12-14 10:42:01', 'Kolbuszowa', 9, 1, 'http://img04.allegroimg.pl/photos/128x96/37/11/79/74/3711797443', '19596015', 1, 2000, 100, 6),
(639, 7106, 2, 1, 3651776312, 'Lokal, Wojaszówka', 1100, '2013-11-22 09:26:09', 'Wojaszówka', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/36/51/77/63/3651776312', '11625223', 1, 1100, 210, 6),
(640, 7106, 2, 1, 3651819414, 'Lokal, Iwonicz-Zdrój', 850, '2013-11-22 09:41:05', 'Iwonicz-Zdrój', 9, 1, 'http://img15.allegroimg.pl/photos/128x96/36/51/81/94/3651819414', '14824138', 2, 850, 133, 6),
(641, 7106, 2, 1, 3667757205, 'Lokal, Wojaszówka, Wojaszówka', 1800, '2013-11-28 05:06:32', 'Wojaszówka', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/67/75/72/3667757205', '15877051', 1, 1800, 235, 6),
(647, 7106, 2, 1, 3707049757, 'Lokal, Krościenko Wyżne', 3000, '2013-12-12 16:26:44', 'Krościenko Wyżne', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/37/07/04/97/3707049757', '20196336', 2, 3000, 200, 6),
(666, 7108, 2, 1, 3672308390, 'Lokal, Nowa Sarzyna', 3500, '2013-11-29 19:11:58', 'Nowa Sarzyna', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/36/72/30/83/3672308390', '8553010', 1, 3500, 102, 6),
(669, 7108, 2, 1, 3715150654, 'Lokal, Leżajsk', 1200, '2013-12-15 11:14:07', 'Leżajsk', 9, 1, 'http://img15.allegroimg.pl/photos/128x96/37/15/15/06/3715150654', '21794665', 2, 1200, 50, 6),
(678, 7110, 2, 1, 3663837982, 'Lokal, Kraczkowa', 5000, '2013-11-26 19:07:19', 'Kraczkowa', 9, 1, 'http://img03.allegroimg.pl/photos/128x96/36/63/83/79/3663837982', '20441213', 1, 7500, 243, 6),
(680, 7110, 2, 1, 3672311780, 'Lokal, Kraczkowa', 1230, '2013-11-29 19:14:48', 'Kraczkowa', 9, 1, 'http://img01.allegroimg.pl/photos/128x96/36/72/31/17/3672311780', '13598740', 1, 1230, 130, 6),
(685, 7110, 2, 1, 3689395325, 'Lokal, Łańcut', 7500, '2013-12-06 09:07:23', 'Łańcut', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/89/39/53/3689395325', '21078880', 1, 7500, 250, 6),
(690, 7110, 2, 1, 3711743470, 'Lokal, Łańcut', 7000, '2013-12-14 10:19:36', 'Łańcut', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/37/11/74/34/3711743470', '22292288', 1, 7000, 220, 6),
(691, 7110, 2, 1, 3723197231, 'Lokal, Łańcut, RYNEK', 6500, '2013-12-18 10:11:00', 'Łańcut', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/37/23/19/72/3723197231', '22357533', 2, 9750, 100, 6),
(692, 7110, 2, 1, 3727298474, 'Lokal, Łańcut', 2820, '2013-12-19 15:27:24', 'Łańcut', 9, 1, 'http://img15.allegroimg.pl/photos/128x96/37/27/29/84/3727298474', '19620133', 1, 5640, 141, 6),
(698, 7110, 2, 1, 3727417250, 'Lokal, Łańcut, okolice  Łańcuta', 1730, '2013-12-19 16:11:18', 'Łańcut', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/37/27/41/72/3727417250', '19620129', 2, 1730, 173, 6),
(699, 7110, 2, 1, 3729174095, 'Lokal, Kraczkowa', 5000, '2013-12-20 09:09:52', 'Kraczkowa', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/37/29/17/40/3729174095', '5301652', 1, 5000, 250, 6),
(711, 7111, 2, 1, 3651994405, 'Lokal, Mielec', 1000, '2013-11-22 10:33:03', 'Mielec', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/51/99/44/3651994405', '18620302', 2, 1000, 100, 6),
(713, 7111, 2, 1, 3658584023, 'Lokal, Mielec', 1000, '2013-11-24 15:31:52', 'Mielec', 9, 1, 'http://img04.allegroimg.pl/photos/128x96/36/58/58/40/3658584023', '16608264', 1, 1000, 186, 6),
(717, 7111, 2, 1, 3660383535, 'Lokal, Mielec', 3000, '2013-11-25 11:02:46', 'Mielec', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/36/60/38/35/3660383535', '17153928', 1, 3000, 200, 6),
(718, 7111, 2, 1, 3660384429, 'Lokal, Mielec', 1500, '2013-11-25 11:02:46', 'Mielec', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/36/60/38/44/3660384429', '17153860', 1, 1500, 100, 6),
(725, 7111, 2, 1, 3669233125, 'Lokal, Mielec, osiedle', 1000, '2013-11-28 17:02:54', 'Mielec', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/69/23/31/3669233125', '11180668', 1, 1500, 74, 6),
(729, 7111, 2, 1, 3671541404, 'Lokal, Mielec', 3000, '2013-11-29 14:37:16', 'Mielec', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/36/71/54/14/3671541404', '16619317', 1, 3000, 80, 6),
(732, 7111, 2, 1, 3671541467, 'Lokal, Mielec', 2200, '2013-11-29 14:37:18', 'Mielec', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/36/71/54/14/3671541467', '12562870', 2, 2200, 90, 6),
(738, 7111, 2, 1, 3672311635, 'Lokal, Mielec', 2000, '2013-11-29 19:14:41', 'Mielec', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/36/72/31/16/3672311635', '13598102', 1, 2000, 185, 6),
(742, 7111, 2, 1, 3686684805, 'Lokal, Mielec', 1500, '2013-12-05 09:57:54', 'Mielec', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/86/68/48/3686684805', '16390216', 2, 1500, 100, 6),
(743, 7111, 2, 1, 3686684819, 'Lokal, Mielec, szafera', 5000, '2013-12-05 09:57:54', 'Mielec', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/36/86/68/48/3686684819', '16332605', 1, 5000, 247, 6),
(747, 7111, 2, 1, 3725099596, 'Lokal, Mielec', 2900, '2013-12-05 17:02:34', 'Mielec', 9, 1, 'http://img17.allegroimg.pl/photos/128x96/37/25/09/95/3725099596', '15611218', 2, 2900, 230, 6),
(754, 7112, 2, 1, 3693574426, 'Lokal, Rudnik nad Sanem, Mickiewicza 57', 1500, '2013-12-07 17:05:11', 'Rudnik nad Sanem', 9, 1, 'http://img07.allegroimg.pl/photos/128x96/36/93/57/44/3693574426', '17477285', 2, 1500, 200, 6),
(767, 7116, 2, 1, 3672309160, 'Lokal, Zabajka', 3100, '2013-11-29 19:12:25', 'Zabajka', 9, 1, 'http://img01.allegroimg.pl/photos/128x96/36/72/30/91/3672309160', '9768190', 1, 3100, 180, 6),
(773, 7116, 2, 1, 3681695534, 'Lokal, Krasne', 1800, '2013-12-03 15:12:43', 'Krasne', 9, 1, 'http://img15.allegroimg.pl/photos/128x96/36/81/69/55/3681695534', '15401858', 2, 1800, 240, 6),
(774, 7116, 2, 1, 3681700587, 'Lokal, Głogów Małopolski', 3120, '2013-12-03 15:17:46', 'Głogów Małopolski', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/36/81/70/05/3681700587', '9659506', 2, 3120, 240, 6),
(776, 7116, 2, 1, 3690180245, 'Lokal, Tyczyn', 1500, '2013-12-06 13:38:15', 'Tyczyn', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/90/18/02/3690180245', '22156459', 1, 1500, 45, 6),
(778, 7116, 2, 1, 3709726041, 'Lokal, Rudna Mała', 3300, '2013-12-13 15:11:50', 'Rudna Mała', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/37/09/72/60/3709726041', '21757729', 1, 4950, 110, 6),
(781, 7116, 2, 1, 3713328751, 'Lokal, Głogów Małopolski, Kościuszki 1', 5734, '2013-12-14 17:49:45', 'Głogów Małopolski', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/37/13/32/87/3713328751', '22302277', 1, 5734, 229, 6),
(783, 7116, 2, 1, 3715702186, 'Lokal, Rudna Wielka, Rudna Wielka', 1000, '2013-12-15 14:26:39', 'Rudna Wielka', 9, 1, 'http://img07.allegroimg.pl/photos/128x96/37/15/70/21/3715702186', '9168536', 2, 1500, 100, 6),
(784, 7116, 2, 1, 3727298514, 'Lokal, Głogów Małopolski', 2500, '2013-12-19 15:27:20', 'Głogów Małopolski', 9, 1, 'http://img15.allegroimg.pl/photos/128x96/37/27/29/85/3727298514', '20034189', 2, 2500, 115, 6),
(790, 7116, 2, 1, 3727299658, 'Lokal, Rudna Mała', 3000, '2013-12-19 15:28:41', 'Rudna Mała', 9, 1, 'http://img19.allegroimg.pl/photos/128x96/37/27/29/96/3727299658', '17586724', 2, 3000, 120, 6),
(798, 7116, 2, 1, 3727300986, 'Lokal, Świlcza', 3000, '2013-12-19 15:29:46', 'Świlcza', 9, 1, 'http://img07.allegroimg.pl/photos/128x96/37/27/30/09/3727300986', '16073194', 2, 3000, 180, 6),
(800, 7116, 2, 1, 3727314258, 'Lokal, Rudna Mała', 1716, '2013-12-19 15:32:29', 'Rudna Mała', 9, 1, 'http://img19.allegroimg.pl/photos/128x96/37/27/31/42/3727314258', '15198832', 1, 1716, 78, 6),
(807, 7116, 2, 1, 3727412677, 'Lokal, Kielnarowa', 1500, '2013-12-19 16:07:47', 'Kielnarowa', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/37/27/41/26/3727412677', '7894735', 1, 1500, 100, 6),
(813, 7117, 2, 1, 3652125225, 'Lokal, Prusiek, Prusiek', 18000, '2013-11-22 11:24:36', 'Prusiek', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/52/12/52/3652125225', '19252952', 1, 18000, 230, 6),
(815, 7117, 2, 1, 3653845091, 'Lokal, Sanok, Sobieskiego', 5000, '2013-11-23 05:08:05', 'Sanok', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/36/53/84/50/3653845091', '20389078', 2, 5000, 89, 6),
(816, 7117, 2, 1, 3671616918, 'Lokal, Sanok, 3-go Maja', 1000, '2013-11-29 15:05:47', 'Sanok', 9, 1, 'http://img19.allegroimg.pl/photos/128x96/36/71/61/69/3671616918', '8570894', 2, 1000, 70, 6),
(822, 7117, 2, 1, 3692000439, 'Lokal, Sanok, Jana III Sobieskiego', 1780, '2013-12-07 03:09:48', 'Sanok', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/36/92/00/04/3692000439', '17986913', 2, 1780, 178, 6),
(823, 7117, 2, 1, 3698420704, 'Lokal, Sanok, 3-go Maja', 4000, '2013-12-09 13:06:55', 'Sanok', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/36/98/42/07/3698420704', '17999613', 2, 4000, 121.7, 6),
(824, 7117, 2, 1, 3728915364, 'Lokal, Sanok, Sobieskiego', 10000, '2013-12-20 06:08:53', 'Sanok', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/37/28/91/53/3728915364', '20332819', 1, 10000, 178, 6),
(833, 7118, 2, 1, 3686972472, 'Lokal, Stalowa Wola', 1800, '2013-12-05 11:52:17', 'Stalowa Wola', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/36/86/97/24/3686972472', '21058270', 1, 2700, 72, 6),
(834, 7119, 2, 1, 3727295179, 'Lokal, Babica', 5000, '2013-11-23 16:06:23', 'Babica', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/37/27/29/51/3727295179', '21405087', 2, 5000, 200, 6),
(839, 7119, 2, 1, 3725909384, 'Lokal, Strzyżów', 1400, '2013-12-19 04:09:29', 'Strzyżów', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/37/25/90/93/3725909384', '16268146', 1, 1400, 125.74, 6),
(841, 7120, 2, 1, 3691987424, 'Lokal, Nowa Dęba, Jana Pawła II', 1500, '2013-12-07 02:02:29', 'Nowa Dęba', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/36/91/98/74/3691987424', '17183781', 1, 1500, 60, 6);";

    private $sqlCatItem1 = "INSERT INTO `allegro_category_item` (`id`, `category_id`, `advert_service_id`, `user_id`, `item_id`, `name`, `buy_now_price`, `ending_time`, `city`, `state`, `country`, `thumb_url`, `id_in_advert_service`, `period_of_notice`, `bail`, `surface`, `type_id`) VALUES
(842, 7736, 2, 1, 3681422497, 'Hala/magazyn, Krosno', 1300, '2013-12-03 13:23:25', 'Krosno', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/36/81/42/24/3681422497', '21592096', 1, 1300, 160, 8),
(843, 7736, 2, 1, 3696841756, 'Hala/magazyn, Krosno', 11957, '2013-12-08 19:08:05', 'Krosno', 9, 1, 'http://img17.allegroimg.pl/photos/128x96/36/96/84/17/3696841756', '20137434', 1, 11957, 1087, 7),
(844, 7736, 2, 1, 3703903070, 'Hala/magazyn, Krosno, Krosno', 11847, '2013-12-11 16:05:38', 'Krosno', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/37/03/90/30/3703903070', '19629488', 2, 11847, 1077, 7),
(845, 7736, 2, 1, 3722693588, 'Hala/magazyn, Krosno', 16305, '2013-12-18 03:08:32', 'Krosno', 9, 1, 'http://img09.allegroimg.pl/photos/128x96/37/22/69/35/3722693588', '14034716', 2, 16305, 1087, 7),
(846, 7736, 2, 1, 3726810115, 'Hala/magazyn, Krosno, Pużaka ', 3000, '2013-12-19 12:56:05', 'Krosno', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/37/26/81/01/3726810115', '22382917', 1, 3000, 210, 8),
(847, 7737, 2, 1, 3687676671, 'Hala/magazyn, Przemyśl, Sielec', 10000, '2013-11-22 07:32:23', 'Przemyśl', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/36/87/67/66/3687676671', '17148768', 1, 15000, 978, 8),
(849, 7737, 2, 1, 3717284711, 'Hala/magazyn, Przemyśl, Aleksandra Dworskiego', 660, '2013-12-16 01:11:58', 'Przemyśl', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/37/17/28/47/3717284711', '18149474', 1, 540, 18, 8),
(850, 7737, 2, 1, 3717297535, 'Hala/magazyn, Przemyśl', 3192, '2013-12-16 02:11:04', 'Przemyśl', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/37/17/29/75/3717297535', '18151349', 1, 3192, 228.8, 8),
(852, 7738, 2, 1, 3651266807, 'Hala/magazyn, Rzeszów, Zwięczyca', 18000, '2013-11-22 00:11:44', 'Rzeszów', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/36/51/26/68/3651266807', '20000473', 1, 18000, 1300, 7),
(854, 7738, 2, 1, 3652067651, 'Hala/magazyn, Rzeszów, Zwięczyca', 30400, '2013-11-22 11:06:12', 'Rzeszów', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/36/52/06/76/3652067651', '18125095', 2, 30400, 1600, 7),
(855, 7738, 2, 1, 3723323790, 'Hala/magazyn, Rzeszów', 24000, '2013-11-22 12:06:58', 'Rzeszów', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/37/23/32/37/3723323790', '21920243', 1, 24000, 1500, 7),
(856, 7738, 2, 1, 3723323785, 'Hala/magazyn, Rzeszów', 24864, '2013-11-22 12:07:01', 'Rzeszów', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/37/23/32/37/3723323785', '21920253', 2, 24864, 2072, 7),
(857, 7738, 2, 1, 3574332010, 'Hala/magazyn, Rzeszów', 18400, '2013-11-22 21:00:39', 'Rzeszów', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/35/74/33/20/3574332010', '11071389', 1, 18400, 1150, 7),
(858, 7738, 2, 1, 3574335861, 'Hala/magazyn, Rzeszów', 8500, '2013-11-22 21:01:43', 'Rzeszów', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/35/74/33/58/3574335861', '16248904', 1, 8500, 590, 8),
(859, 7738, 2, 1, 3653726469, 'Hala/magazyn, Rzeszów, al. Wyzwolenia', 5180, '2013-11-23 01:02:02', 'Rzeszów', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/36/53/72/64/3653726469', '18262961', 1, 5180, 370, 8),
(860, 7738, 2, 1, 3656135932, 'Hala/magazyn, Rzeszów, al. Wincentego Witosa', 20900, '2013-11-23 19:01:50', 'Rzeszów', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/36/56/13/59/3656135932', '18275452', 1, 20900, 1100, 7),
(861, 7738, 2, 1, 3656136227, 'Hala/magazyn, Rzeszów, Podkarpacka', 2500, '2013-11-23 19:01:51', 'Rzeszów', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/36/56/13/62/3656136227', '18275463', 2, 5000, 230, 8),
(862, 7738, 2, 1, 3662132096, 'Hala/magazyn, Rzeszów, Miłocin', 24000, '2013-11-26 07:08:38', 'Rzeszów', 9, 1, 'http://img17.allegroimg.pl/photos/128x96/36/62/13/20/3662132096', '17249627', 2, 24000, 1600, 7),
(863, 7738, 2, 1, 3662132068, 'Hala/magazyn, Rzeszów, Miłocin', 5860, '2013-11-26 07:08:39', 'Rzeszów', 9, 1, 'http://img09.allegroimg.pl/photos/128x96/36/62/13/20/3662132068', '17249661', 1, 5860, 770, 8),
(864, 7738, 2, 1, 3662132047, 'Hala/magazyn, Rzeszów, Staromieście', 9000, '2013-11-26 07:08:39', 'Rzeszów', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/36/62/13/20/3662132047', '17249645', 1, 9000, 590, 8),
(865, 7738, 2, 1, 3662132021, 'Hala/magazyn, Rzeszów, Zalesie', 20000, '2013-11-26 07:08:40', 'Rzeszów', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/36/62/13/20/3662132021', '17249694', 1, 20000, 1325, 7),
(866, 7738, 2, 1, 3662132033, 'Hala/magazyn, Rzeszów, Wilkowyja', 40500, '2013-11-26 07:08:40', 'Rzeszów', 9, 1, 'http://img14.allegroimg.pl/photos/128x96/36/62/13/20/3662132033', '17249754', 2, 40500, 2250, 7),
(869, 7738, 2, 1, 3662132079, 'Hala/magazyn, Rzeszów, Zwięczyca, Podkarpacka', 4800, '2013-11-26 07:08:41', 'Rzeszów', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/36/62/13/20/3662132079', '17249810', 1, 4800, 300, 8),
(870, 7738, 2, 1, 3662132084, 'Hala/magazyn, Rzeszów, Podkarpacka', 3500, '2013-11-26 07:08:41', 'Rzeszów', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/36/62/13/20/3662132084', '17249815', 2, 3500, 350, 8),
(871, 7738, 2, 1, 3662132163, 'Hala/magazyn, Rzeszów, Baranówka', 8680, '2013-11-26 07:08:41', 'Rzeszów', 9, 1, 'http://img04.allegroimg.pl/photos/128x96/36/62/13/21/3662132163', '17249802', 1, 8680, 620, 8),
(872, 7738, 2, 1, 3662132070, 'Hala/magazyn, Rzeszów, Baranówka, al. Wyzwolenia', 7200, '2013-11-26 07:08:41', 'Rzeszów', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/36/62/13/20/3662132070', '17249795', 2, 7200, 450, 8),
(873, 7738, 2, 1, 3663628459, 'Hala/magazyn, Rzeszów', 37000, '2013-11-26 18:00:04', 'Rzeszów', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/36/63/62/84/3663628459', '17743245', 1, 37000, 3700, 7),
(874, 7738, 2, 1, 3663627562, 'Hala/magazyn, Rzeszów', 20000, '2013-11-26 18:00:04', 'Rzeszów', 9, 1, 'http://img03.allegroimg.pl/photos/128x96/36/63/62/75/3663627562', '18254304', 2, 20000, 2000, 7),
(875, 7738, 2, 1, 3669562968, 'Hala/magazyn, Rzeszów', 5000, '2013-11-28 19:11:43', 'Rzeszów', 9, 1, 'http://img09.allegroimg.pl/photos/128x96/36/69/56/29/3669562968', '15274991', 2, 5000, 500, 8),
(877, 7738, 2, 1, 3669567545, 'Hala/magazyn, Rzeszów', 24000, '2013-11-28 19:16:51', 'Rzeszów', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/69/56/75/3669567545', '20952239', 1, 24000, 1500, 7),
(878, 7738, 2, 1, 3669567557, 'Hala/magazyn, Rzeszów', 12000, '2013-11-28 19:16:51', 'Rzeszów', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/36/69/56/75/3669567557', '20952594', 2, 12000, 750, 8),
(879, 7738, 2, 1, 3673299987, 'Hala/magazyn, Rzeszów, Staromieście, okolice Polfy', 9800, '2013-11-30 08:11:50', 'Rzeszów', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/36/73/29/99/3673299987', '15771310', 2, 9800, 530, 8),
(880, 7738, 2, 1, 3674014141, 'Hala/magazyn, Rzeszów', 1000, '2013-11-30 13:19:46', 'Rzeszów', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/36/74/01/41/3674014141', '18599045', 1, 1000, 100, 8),
(881, 7738, 2, 1, 3674014191, 'Hala/magazyn, Rzeszów', 1800, '2013-11-30 13:19:49', 'Rzeszów', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/36/74/01/41/3674014191', '13990647', 1, 16, 150, 8),
(882, 7738, 2, 1, 3674492770, 'Hala/magazyn, Rzeszów', 3200, '2013-11-30 16:09:21', 'Rzeszów', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/36/74/49/27/3674492770', '11802074', 1, 3200, 400, 8),
(883, 7738, 2, 1, 3674492881, 'Hala/magazyn, Rzeszów', 3600, '2013-11-30 16:09:54', 'Rzeszów', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/36/74/49/28/3674492881', '14527751', 2, 3600, 300, 8),
(884, 7738, 2, 1, 3675067402, 'Hala/magazyn, Rzeszów', 20000, '2013-11-30 19:53:06', 'Rzeszów', 9, 1, 'http://img03.allegroimg.pl/photos/128x96/36/75/06/74/3675067402', '15771884', 2, 20000, 2000, 7),
(885, 7738, 2, 1, 3675067455, 'Hala/magazyn, Rzeszów', 6266, '2013-11-30 19:53:56', 'Rzeszów', 9, 1, 'http://img16.allegroimg.pl/photos/128x96/36/75/06/74/3675067455', '9693749', 1, 9399, 482, 8),
(886, 7738, 2, 1, 3675688229, 'Hala/magazyn, Rzeszów, Staromieście', 18000, '2013-12-01 02:11:56', 'Rzeszów', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/36/75/68/82/3675688229', '18384828', 1, 18000, 1000, 7),
(887, 7738, 2, 1, 3723323877, 'Hala/magazyn, Rzeszów, Staromieście', 19500, '2013-12-01 20:10:29', 'Rzeszów', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/37/23/32/38/3723323877', '18401502', 2, 19500, 1309, 7),
(888, 7738, 2, 1, 3679361176, 'Hala/magazyn, Rzeszów', 26000, '2013-12-02 16:15:47', 'Rzeszów', 9, 1, 'http://img17.allegroimg.pl/photos/128x96/36/79/36/11/3679361176', '20998707', 1, 39000, 1300, 7),
(889, 7738, 2, 1, 3679361219, 'Hala/magazyn, Rzeszów', 17000, '2013-12-02 16:15:50', 'Rzeszów', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/36/79/36/12/3679361219', '21015484', 2, 17000, 1400, 7),
(890, 7738, 2, 1, 3679543800, 'Hala/magazyn, Rzeszów, gen. Mariana Langiewicza', 3570, '2013-12-02 17:14:35', 'Rzeszów', 9, 1, 'http://img01.allegroimg.pl/photos/128x96/36/79/54/38/3679543800', '21574217', 2, 5355, 238, 8),
(892, 7738, 2, 1, 3679994131, 'Hala/magazyn, Rzeszów, Budziwój', 2700, '2013-12-02 19:53:46', 'Rzeszów', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/36/79/99/41/3679994131', '4018885', 2, 2700, 136, 8),
(893, 7738, 2, 1, 3681695444, 'Hala/magazyn, Rzeszów', 1200, '2013-12-03 15:12:30', 'Rzeszów', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/36/81/69/54/3681695444', '21037123', 1, 2400, 150, 8),
(894, 7738, 2, 1, 3681695385, 'Hala/magazyn, Rzeszów', 2670, '2013-12-03 15:12:31', 'Rzeszów', 9, 1, 'http://img06.allegroimg.pl/photos/128x96/36/81/69/53/3681695385', '21034726', 1, 2670, 178, 8),
(895, 7738, 2, 1, 3681695461, 'Hala/magazyn, Rzeszów', 2400, '2013-12-03 15:12:31', 'Rzeszów', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/36/81/69/54/3681695461', '21036813', 2, 2400, 300, 8),
(896, 7738, 2, 1, 3681695478, 'Hala/magazyn, Rzeszów', 24862, '2013-12-03 15:12:32', 'Rzeszów', 9, 1, 'http://img19.allegroimg.pl/photos/128x96/36/81/69/54/3681695478', '21034343', 2, 24862, 2072, 7),
(898, 7738, 2, 1, 3681695406, 'Hala/magazyn, Rzeszów', 2250, '2013-12-03 15:12:41', 'Rzeszów', 9, 1, 'http://img07.allegroimg.pl/photos/128x96/36/81/69/54/3681695406', '16829594', 2, 2250, 150, 8),
(900, 7738, 2, 1, 3681695448, 'Hala/magazyn, Rzeszów', 15000, '2013-12-03 15:12:42', 'Rzeszów', 9, 1, 'http://img09.allegroimg.pl/photos/128x96/36/81/69/54/3681695448', '16829477', 1, 15000, 1000, 7),
(901, 7739, 2, 1, 3649712472, 'Hala/magazyn, Tarnobrzeg', 13200, '2013-11-21 13:50:35', 'Tarnobrzeg', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/36/49/71/24/3649712472', '11675129', 2, 13200, 1100, 7),
(902, 7739, 2, 1, 3721336292, 'Hala/magazyn, Tarnobrzeg, stale, Stale', 12000, '2013-12-17 17:07:56', 'Tarnobrzeg', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/37/21/33/62/3721336292', '16688387', 2, 12000, 2850, 7),
(904, 7742, 2, 1, 3706447580, 'Hala/magazyn, Dębica', 6150, '2013-12-12 12:41:25', 'Dębica', 9, 1, 'http://img01.allegroimg.pl/photos/128x96/37/06/44/75/3706447580', '19413690', 2, 9225, 350, 8),
(905, 7743, 2, 1, 3652067686, 'Hala/magazyn, Jarosław', 40800, '2013-11-22 11:06:13', 'Jarosław', 9, 1, 'http://img07.allegroimg.pl/photos/128x96/36/52/06/76/3652067686', '18129690', 2, 61200, 2400, 7),
(906, 7743, 2, 1, 3654831910, 'Hala/magazyn, Jarosław, Kruhel Pełkiński 72', 9800, '2013-11-23 12:24:05', 'Jarosław', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/36/54/83/19/3654831910', '11711170', 1, 9800, 800, 8),
(907, 7743, 2, 1, 3709008270, 'Hala/magazyn, Jarosław', 40800, '2013-12-13 11:09:08', 'Jarosław', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/37/09/00/82/3709008270', '22267703', 2, 40800, 2400, 7),
(911, 7744, 2, 1, 3673041081, 'Hala/magazyn, Skołyszyn', 1100, '2013-11-30 00:09:17', 'Skołyszyn', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/36/73/04/10/3673041081', '9532720', 2, 1100, 100, 8),
(912, 7744, 2, 1, 3715321944, 'Hala/magazyn, Jasło', 5368, '2013-12-15 12:15:45', 'Jasło', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/37/15/32/19/3715321944', '20742178', 2, 5368, 671, 8),
(913, 7745, 2, 1, 3714967447, 'Hala/magazyn, Cmolas', 35000, '2013-12-15 10:08:42', 'Cmolas', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/37/14/96/74/3714967447', '18004063', 1, 35000, 1620, 7),
(914, 7747, 2, 1, 3647838351, 'Hala/magazyn, Lesko, przemysłowa', 5000, '2013-12-20 19:02:06', 'Lesko', 9, 1, '', '17969684', 2, 5000, 1000, 7),
(915, 7749, 2, 1, 3710067462, 'Hala/magazyn, Lubaczów', 1500, '2013-12-13 17:14:15', 'Lubaczów', 9, 1, 'http://img03.allegroimg.pl/photos/128x96/37/10/06/74/3710067462', '22274664', 2, 1500, 130, 8),
(916, 7749, 2, 1, 3365518624, 'Hala/magazyn, Lisie Jamy', 1000, '2013-12-27 21:32:06', 'Lisie Jamy', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/33/65/51/86/3365518624', '19935774', 1, 2, 432, 8),
(917, 7750, 2, 1, 3649691521, 'Hala/magazyn, Krzemienica', 6000, '2013-11-21 13:49:39', 'Krzemienica', 9, 1, 'http://img02.allegroimg.pl/photos/128x96/36/49/69/15/3649691521', '18637045', 1, 6000, 1000, 7),
(918, 7750, 2, 1, 3649712524, 'Hala/magazyn, Kraczkowa', 1500, '2013-11-21 13:50:35', 'Kraczkowa', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/36/49/71/25/3649712524', '11710448', 2, 1500, 100, 8),
(920, 7750, 2, 1, 3677492683, 'Hala/magazyn, Łańcut, Głuchów', 1500, '2013-12-01 20:20:10', 'Łańcut', 9, 1, 'http://img04.allegroimg.pl/photos/128x96/36/77/49/26/3677492683', '17235841', 1, 15, 300, 8),
(921, 7750, 2, 1, 3679196943, 'Hala/magazyn, Łańcut, Podzwierzyniec', 2100, '2013-12-02 15:07:43', 'Łańcut', 9, 1, 'http://img04.allegroimg.pl/photos/128x96/36/79/19/69/3679196943', '18906130', 1, 3150, 300, 8),
(922, 7750, 2, 1, 3683215637, 'Hala/magazyn, Łańcut', 1500, '2013-12-04 06:04:54', 'Łańcut', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/36/83/21/56/3683215637', '12726365', 2, 1500, 100, 8),
(923, 7750, 2, 1, 3717952224, 'Hala/magazyn, Dąbrówki', 30000, '2013-12-16 12:08:18', 'Dąbrówki', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/37/17/95/22/3717952224', '3465350', 1, 45000, 1057, 7),
(924, 7750, 2, 1, 3729174030, 'Hala/magazyn, Łańcut', 4500, '2013-12-20 09:09:50', 'Łańcut', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/37/29/17/40/3729174030', '4703543', 2, 4500, 540, 8),
(925, 7751, 2, 1, 3725101051, 'Hala/magazyn, Mielec', 2900, '2013-11-21 12:21:40', 'Mielec', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/37/25/10/10/3725101051', '15669421', 1, 2900, 230, 8),
(926, 7751, 2, 1, 3651743310, 'Hala/magazyn, Mielec', 16720, '2013-11-22 09:16:49', 'Mielec', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/36/51/74/33/3651743310', '9644258', 1, 16720, 1000, 7),
(929, 7751, 2, 1, 3658584929, 'Hala/magazyn, Mielec', 1200, '2013-11-24 15:32:18', 'Mielec', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/36/58/58/49/3658584929', '15182745', 1, 12, 150, 8),
(930, 7751, 2, 1, 3658585757, 'Hala/magazyn, Mielec', 1300, '2013-11-24 15:33:11', 'Mielec', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/36/58/58/57/3658585757', '13146380', 1, 1300, 200, 8),
(931, 7751, 2, 1, 3658585751, 'Hala/magazyn, Mielec', 1800, '2013-11-24 15:33:12', 'Mielec', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/36/58/58/57/3658585751', '13146183', 2, 1800, 180, 8),
(932, 7751, 2, 1, 3660384486, 'Hala/magazyn, Mielec', 3000, '2013-11-25 11:02:46', 'Mielec', 9, 1, 'http://img07.allegroimg.pl/photos/128x96/36/60/38/44/3660384486', '17150029', 1, 3000, 200, 8),
(933, 7751, 2, 1, 3660384557, 'Hala/magazyn, Mielec', 10000, '2013-11-25 11:02:46', 'Mielec', 9, 1, 'http://img18.allegroimg.pl/photos/128x96/36/60/38/45/3660384557', '17149681', 1, 15000, 1000, 7),
(935, 7751, 2, 1, 3671284312, 'Hala/magazyn, Mielec', 10000, '2013-11-29 13:01:37', 'Mielec', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/36/71/28/43/3671284312', '18737834', 1, 10000, 360, 8),
(936, 7751, 2, 1, 3725099553, 'Hala/magazyn, Mielec, Stary Mielec', 1800, '2013-12-05 17:04:17', 'Mielec', 9, 1, 'http://img14.allegroimg.pl/photos/128x96/37/25/09/95/3725099553', '18982083', 1, 2700, 150, 8),
(937, 7751, 2, 1, 3725099560, 'Hala/magazyn, Mielec, Stary Mielec', 3960, '2013-12-05 17:04:17', 'Mielec', 9, 1, 'http://img01.allegroimg.pl/photos/128x96/37/25/09/95/3725099560', '18982068', 1, 3960, 330, 8),
(939, 7751, 2, 1, 3706681770, 'Hala/magazyn, Mielec', 2400, '2013-12-12 14:27:27', 'Mielec', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/37/06/68/17/3706681770', '20632308', 1, 2400, 202, 8),
(941, 7751, 2, 1, 3706701792, 'Hala/magazyn, Mielec', 22080, '2013-12-12 14:35:19', 'Mielec', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/37/06/70/17/3706701792', '12043878', 2, 22080, 1380, 7),
(942, 7751, 2, 1, 3708961712, 'Hala/magazyn, Mielec', 9120, '2013-12-13 10:55:00', 'Mielec', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/37/08/96/17/3708961712', '15241614', 2, 9120, 760, 8),
(943, 7751, 2, 1, 3711875532, 'Hala/magazyn, Mielec, Przemysłowa część miasta', 21760, '2013-12-14 11:08:40', 'Mielec', 9, 1, 'http://img13.allegroimg.pl/photos/128x96/37/11/87/55/3711875532', '12980606', 2, 21760, 2176, 7),
(944, 7751, 2, 1, 3712007169, 'Hala/magazyn, Mielec', 4600, '2013-12-14 11:53:06', 'Mielec', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/37/12/00/71/3712007169', '13677015', 1, 4600, 460, 8),
(945, 7751, 2, 1, 3721336199, 'Hala/magazyn, Mielec', 5500, '2013-12-17 17:07:55', 'Mielec', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/37/21/33/61/3721336199', '16387531', 1, 5500, 90, 8),
(946, 7752, 2, 1, 3670052669, 'Hala/magazyn, Rudnik nad Sanem, Rzeszowska', 1000, '2013-11-28 21:49:08', 'Rudnik nad Sanem', 9, 1, 'http://img10.allegroimg.pl/photos/128x96/36/70/05/26/3670052669', '22029804', 1, 1000, 200, 8),
(947, 7752, 2, 1, 3683222064, 'Hala/magazyn, Rudnik nad Sanem, Rzeszowska', 10600, '2013-12-04 06:41:22', 'Rudnik nad Sanem', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/36/83/22/20/3683222064', '15991537', 2, 10600, 2650, 7),
(957, 7756, 2, 1, 3656990660, 'Hala/magazyn, Rudna Mała', 28000, '2013-11-24 00:02:59', 'Rudna Mała', 9, 1, 'http://img01.allegroimg.pl/photos/128x96/36/56/99/06/3656990660', '19866847', 1, 42000, 1750, 7),
(959, 7756, 2, 1, 3662132090, 'Hala/magazyn, Jasionka', 132600, '2013-11-26 07:08:38', 'Jasionka', 9, 1, 'http://img11.allegroimg.pl/photos/128x96/36/62/13/20/3662132090', '17249622', 1, 132600, 7800, 7),
(962, 7756, 2, 1, 3662132031, 'Hala/magazyn, Rudna Mała', 7800, '2013-11-26 07:08:39', 'Rudna Mała', 9, 1, 'http://img12.allegroimg.pl/photos/128x96/36/62/13/20/3662132031', '17249673', 2, 7800, 1300, 7),
(968, 7756, 2, 1, 3706450456, 'Hala/magazyn, Krasne', 1000, '2013-12-12 12:41:29', 'Krasne', 9, 1, 'http://img17.allegroimg.pl/photos/128x96/37/06/45/04/3706450456', '13966116', 2, 1000, 90, 8),
(973, 7756, 2, 1, 3726458904, 'Hala/magazyn, Tyczyn, Orkana', 42050, '2013-12-19 10:58:52', 'Tyczyn', 9, 1, 'http://img05.allegroimg.pl/photos/128x96/37/26/45/89/3726458904', '19138154', 2, 63075, 29502, 7),
(974, 7757, 2, 1, 3522193848, 'Hala/magazyn, Sanok, ul. Przemyska', 2460, '2013-12-02 14:31:06', 'Sanok', 9, 1, 'http://img09.allegroimg.pl/photos/128x96/35/22/19/38/3522193848', '21019210', 2, 2460, 200, 8),
(976, 7758, 2, 1, 3686972477, 'Hala/magazyn, Stalowa Wola, Przemysłowa', 1800, '2013-12-05 11:52:18', 'Stalowa Wola', 9, 1, '', '21058235', 2, 1800, 170, 8),
(980, 7758, 2, 1, 3729175259, 'Hala/magazyn, Stalowa Wola', 28080, '2013-12-20 09:11:48', 'Stalowa Wola', 9, 1, 'http://img20.allegroimg.pl/photos/128x96/37/29/17/52/3729175259', '11675049', 2, 28080, 2340, 7),
(982, 7760, 2, 1, 3649712502, 'Hala/magazyn, Nowa Dęba', 16200, '2013-11-21 13:50:35', 'Nowa Dęba', 9, 1, 'http://img03.allegroimg.pl/photos/128x96/36/49/71/25/3649712502', '11675247', 1, 16200, 1350, 7),
(984, 7760, 2, 1, 3591316347, 'Hala/magazyn, Nowa Dęba, szypowskiego 1 ', 13530, '2013-12-29 13:12:04', 'Nowa Dęba', 9, 1, 'http://img08.allegroimg.pl/photos/128x96/35/91/31/63/3591316347', '21503783', 1, 13530, 1100, 7);";


    private $sqlAdvertService = "INSERT INTO `allegro_category_item_advert_service` (`id`, `name`) VALUES
(17, 'Brak'),
(1, 'otoMoto.pl'),
(2, 'otoDom.pl'),
(3, 'otoWakacje.pl'),
(4, 'AlleWakacje.pl'),
(5, 'Oferia.pl'),
(6, 'Tablica.pl'),
(7, 'ebooki.allegro.pl'),
(10, 'otoMoto.cz'),
(11, 'Hotel.cz'),
(12, 'Bezrealitky.cz'),
(13, 'Spa.cz'),
(14, 'Turistik.cz'),
(15, 'Wikireality.cz'),
(16, 'iDeveloper.cz');";

    private $sqlUsers = "INSERT INTO `allegro_user` (`id`, `user_id`, `name`, `rating`) VALUES
(1, 5771210, 'otodom_pl', 0),
(2, 5771210, 'otodom_pl', 0),
(3, 5771210, 'otodom_pl', 0),
(4, 5771210, 'otodom_pl', 0),
(5, 5771210, 'otodom_pl', 0),
(6, 5771210, 'otodom_pl', 0),
(7, 5771210, 'otodom_pl', 0),
(8, 23440228, 'szalony_rz', 70),
(9, 16999859, 'womarfood', 16),
(10, 7000296, 'FirmaWalter', 553),
(11, 7000296, 'FirmaWalter', 553),
(12, 2164557, 'Joaska2', 42),
(13, 5117645, 'kedzior128', 196),
(14, 4320935, 'mirekw299', 77),
(15, 2983409, 'okner', 81),
(16, 4971486, 'szentes1', 154);";

    private $sqlItems = "INSERT INTO `allegro_category_item` (`category_id`, `advert_service_id`, `type_id`, `user_id`, `item_id`, `name`, `buy_now_price`, `ending_time`, `city`, `state`, `country`, `thumb_url`, `period_of_notice`, `bail`, `surface`, `id_in_advert_service`) VALUES
(7736, 1, 2, 1, 3681422222, 'Audi A3', 15000, '2013-12-03 13:23:25', 'Warszawa', 9, 1, '', 0, 15000, 0, '21522222'),
(7736, 1, 2, 1, 3681433333, 'Audi A6', 22000, '2013-12-03 13:23:25', 'Osiek', 9, 1, '0', 0, 22000, 0, '21533333'),
(7736, 1, 2, 1, 3681411111, 'Fiat Panda', 8000, '2013-12-03 13:23:25', 'Krosno', 9, 1, '0', 0, 8000, 0, '21511111'),
(7736, 1, 2, 1, 3681444444, 'Aston Martin DB9', 90000, '2013-12-03 13:23:25', 'Warszawa', 9, 1, '', 0, 90000, 0, '21544444'),
(7736, 1, 2, 1, 3681455555, 'Fiat Uno', 8000, '2013-12-03 13:23:25', 'Osiek', 9, 1, '0', 0, 8000, 0, '21555555'),
(7736, 1, 2, 1, 3681466666, 'Audi A4', 11000, '2013-12-03 13:23:25', 'Warszawa', 9, 1, '', 0, 11000, 0, '21566666'),
(7736, 5, 3, 1, 3681466666, 'ASUS B43V', 3600, '2013-12-03 13:23:25', 'Warszawa', 9, 1, '', 0, 1500, 0, '21566666'),
(7736, 5, 3, 1, 3681477777, 'Laptop Asus G750JX', 4500, '2013-12-03 13:23:25', 'Warszawa', 9, 1, '', 0, 4500, 0, '21577777'),
(7736, 1, 2, 1, 3681488888, 'Ford Mondeo', 9000, '2013-12-03 13:23:25', 'Krosno', 9, 1, '', 0, 9000, 0, '21588888'),
(7736, 5, 3, 1, 3681499999, 'Dell Optiplex 210L', 4500, '2013-12-03 13:23:25', 'Krosno', 9, 1, '', 0, 4500, 0, '21599999'),
(7736, 5, 3, 1, 368199999, 'DELL 15R', 3700, '2013-12-03 13:23:25', 'Osiek', 9, 1, '', 0, 2500, 0, '21599999'),
(7736, 5, 3, 1, 1234512345, 'HP ProBook 655 G1', 4000, '2013-12-03 13:23:25', 'Osiek', 9, 1, '', 0, 2500, 0, '1234512345'),
(7736, 5, 3, 1, 12345123450, 'HP dc9800', 5500, '2013-12-03 13:23:25', 'Osiek', 9, 1, '123123421', 0, 5500, 0, '1234512345'),
(7736, 5, 3, 1, 3422314324, 'HP dc7850', 3700, '2013-12-03 13:23:25', 'Osiek', 9, 1, '123123421', 0, 3000, 0, '1234512345'),
(7736, 5, 4, 1, 3681466633, 'Zestaw telefonów Samsung Galaxy Young', 9000, '2013-12-03 13:23:25', 'Warszawa', 9, 1, '', 0, 900, 0, '21566633'),
(7736, 5, 4, 1, 3681466444, 'Samsung Galaxy S5 ', 3600, '2013-12-03 13:23:25', 'Warszawa', 9, 1, '', 0, 1300, 0, '21566444'),
(7736, 5, 4, 1, 3681466555, 'Zestaw telefonów SAMSUNG GALAXY S4', 17000, '2013-12-03 13:23:25', 'Warszawa', 9, 1, '', 0, 1700, 0, '21566555'),
(7736, 5, 4, 1, 3681466111, 'Zestaw telefonów Sony Xperia T LT30P', 8000, '2013-12-03 13:23:25', 'Osiek', 9, 1, '', 0, 800, 0, '21566111'),
(7736, 5, 4, 1, 3681466123, 'Zestaw telefonów SAMSUNG 8250 NEXUS', 10000, '2013-12-03 13:23:25', 'Krosno', 9, 1, '', 0, 1000, 0, '21566123'),
(7736, 6, 5, 1, 36814121212, 'Tablica interaktywna', 4050, '2013-12-03 13:23:25', 'Osiek', 9, 1, '', 0, 1050, 0, '215121212'),
(7736, 6, 5, 1, 11223123, 'Rzutnik Epson EB-​915W', 3800, '2013-12-03 13:23:25', 'Osiek', 9, 1, '', 0, 900, 0, '11223123'),
(7736, 6, 5, 1, 12341234, 'Oprogramowanie', 3550, '2013-12-03 13:23:25', 'Osiek', 9, 1, '', 0, 250, 0, '12341234');";

}